/** @file   fightercontroller.h
 * @brief   Declaraction of FighterController - class.
 * @version $Revision: 1.2 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_FIGHTERCONTROLLER_H
#define H_WWW_FIGHTERCONTROLLER_H

#include "aicontroller.h"

namespace WeWantWar {


/** @class  FighterController
 * @brief   Controls the enemy fighter planes.
 * @author  Tomi Lamminsaari
 *
 * 
 */
class FighterController : public AIController
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================

  /** The states this controller can be in.
   */
  enum {
    /** We're trying to attack our target. */
    STATE_ATTACK,
    /** We're currently shooting our target. */
    STATE_SHOOT,
    /** We should try to get away from our target. */
    STATE_EVADE
  };



  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
	 * @param  pObj                Pointer to object we're controlling.
   */
	FighterController( GameObject* pObj );


	/** Destructor
   */
	virtual ~FighterController();

private:

	/** Copy constructor.
   * @param     rO                Reference to another FighterController
   */
  FighterController( const FighterController& rO );

	/** Assignment operator
   * @param     rO                Reference to another FighterController
   * @return    Reference to us.
   */
  FighterController& operator = ( const FighterController& rO );

public:


  ///
  /// Methods
  /// =======

  /** Updates the controller.
   */
  virtual void updateAI( bool seeTarget, float dist );

  /** Sets the length of the attack phase.
   * @param   aAttackLength     Length of the attack phase in updates.
   */
  void setAttackPhaseLength( int aAttackLength );
  
  /** Sets the evading phase length.
   * @param   aEvadeLength      Length of the evading phase
   */
  void setEvadePhaseLength( int aEvadeLength );  


  ///
  /// Getter methods
  /// ==============


protected:

  ///
  /// Members
  /// =======

  /** Have we seen the player already. */
  bool  m_alerted;
  
  /** Seize fire - counter. After we've done an attack, we wait this
   * time until we re-attack.
   */
  int m_seizeFireCounter;

  /** Which state we're in */
  int m_state;

  /** The attack phase length. */
  int m_attackPhaseLength;

  /** The evading phase length */
  int m_evadePhaseLength;
  
private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif


/**
 * Version history
 * ===============
 * $Log: fightercontroller.h,v $
 * Revision 1.2  2006/03/16 21:08:23  lamminsa
 * setAttackPhaseLength() and setEvadePhaseLength() were
 * added so that we can give more variation to the behaviour.
 *
 * Revision 1.1.1.1  2006/01/21 23:02:41  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:16:56+02  lamminsa
 * Initial revision
 *
 */
 
